/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class ProxyBuilderModel
implements BakedModel {
    private static final List<BakedQuad> EMPTY = new ArrayList<BakedQuad>(0);
    private static final List<Object> EMPTY_KEY = new ArrayList<Object>();
    private BakedModel parent;
    private BakedModel proxy;
    private BlockState stateCache;
    private TextureAtlasSprite iconParticle;

    public ProxyBuilderModel(TextureAtlasSprite iconParticle) {
        this.iconParticle = iconParticle;
    }

    public ProxyBuilderModel(BakedModel parent) {
        this.parent = parent;
    }

    @NotNull
    public List<BakedQuad> m_213637_(BlockState state, Direction side, @NotNull RandomSource rand) {
        if (this.proxy == null || this.stateCache != state) {
            this.setProxy(state);
        }
        if (this.proxy == null) {
            return EMPTY;
        }
        return this.proxy.m_213637_(state, side, rand);
    }

    public boolean m_7541_() {
        BakedModel model = this.getActiveModel();
        return model == null || model.m_7541_();
    }

    public boolean m_7539_() {
        BakedModel model = this.getActiveModel();
        return model != null && model.m_7539_();
    }

    public boolean m_7521_() {
        BakedModel model = this.getActiveModel();
        return model != null && model.m_7521_();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        BakedModel model = this.getActiveModel();
        return model != null ? model.m_6160_() : this.iconParticle;
    }

    @NotNull
    public ItemTransforms m_7442_() {
        BakedModel model = this.getActiveModel();
        return model != null ? model.m_7442_() : ItemTransforms.f_111786_;
    }

    @NotNull
    public ItemOverrides m_7343_() {
        BakedModel model = this.getActiveModel();
        return model != null ? model.m_7343_() : ItemOverrides.f_111734_;
    }

    public boolean m_7547_() {
        BakedModel model = this.getActiveModel();
        return model != null && model.m_7547_();
    }

    public List<Object> getKey(BlockState state) {
        return EMPTY_KEY;
    }

    protected abstract BakedModel buildModel(BlockState var1, BakedModel var2);

    public final BakedModel buildModel(BlockState state) {
        return this.buildModel(state, this.parent);
    }

    private void setProxy(BlockState state) {
        this.stateCache = state;
        this.proxy = state == null ? this.parent : this.buildModel(state, this.parent);
    }

    private BakedModel getActiveModel() {
        return this.proxy != null ? this.proxy : this.parent;
    }
}

